      subroutine logplt (x,y,ye,n,ne,chart,yminx)
c *** see r h landau, program lpott, 1981, ridge mod 2/86
c     semi-log graphing on printer,from pirk,modified by rhl
c      x(i),y(i) are cartesian coordinates to be plotted
c     on standard size 5cycle graph paper
c     ne gt 0 also causes ye to be plotted on same graph
c     ne lt o for non log polar plot
      implicit  real*8   (a-h,o-z)
      real*4 rrjx
      dimension x(1), y(1), chart(61,61), xf(11), ye(1), plot(10), nplot
     1(30)
c      ymin must be lowest power of 10, e.g. -2.,or 3.
c         but not smallest value of y
c
      data plus,pt,blank,ex/1h+,1h.,1h ,1h0/,aminus,point/1h-,1h+/
     1,nit/0/
      if (nit.ne.0) go to 20
      do 10 i=1,29
         j = i-7
         if (i.le.7) plot(i) = chart(i,1)
         if (i.gt.7) nplot(j) = chart(i,1)
 10   continue
 20   nit = 1
      xmin = 0
      xmax = 180.
      ymin = yminx
      ymax = ymin+5.
c     polarization
      if (ne.lt.0) ymin = -1.
      if (ne.lt.0) ymax = 1.5
      rs = 60./(ymax-ymin)
      mm = 6
c     construct graph
      do 30 i=1,61
         do 30 j=1,61
            chart(j,i) = blank
 30   continue
      do 40 i=1,61,10
         do 40 j=1,61,1
            chart(j,i) = pt
 40   continue
      do 50 k=1,mm
         i = (k-1)*rs+1.1
         if (i.gt.61) i = 61
         do 50 j=1,61,2
            chart(i,j) = pt
 50   continue
c     place data on graph
      xlen = (xmax-xmin)/60.
      ylen = (ymax-ymin)/60.
      do 70 i=1,n
         rhl1 = x(i)
         if (rhl1.gt.xmax) rhl1 = xmax
         if (rhl1.lt.xmin) rhl1 = xmin
         rrjx = (rhl1-xmin)/xlen
         jx = ifix(rrjx)
         if (jx.gt.60) jx = 60
         point = plus
         if (y(i).le.0.) point = aminus
         rhl = y(i)
         if (ne.lt.0) go to 60
         y(i) = abs(y(i))
         if (y(i).eq.0.) y(i) = 10.**ymin
         rhl = log10(y(i))
 60      continue
         if (rhl.lt.ymin) rhl = ymin
         if (rhl.gt.ymax) rhl = ymax
         rrjx = (rhl-ymin)/ylen
         iy = ifix(rrjx)
         if (iy.gt.60) iy = 60
         chart(61-iy,1+jx) = point
         if (ne.le.0) go to 70
         if (ye(i).le.0.0) ye(i) = 10.**ymin
         rhl = log10(ye(i))
         if (rhl.lt.ymin) rhl = ymin
         if (rhl.gt.ymax) rhl = ymax
         rrjx = (rhl-ymin)/ylen
         iy = ifix(rrjx)
         if (iy.gt.60) iy = 60
         point = chart(61-iy,1+jx)
         if ((point.eq.plus).or.(point.eq.aminus)) go to 70
         chart(61-iy,1+jx) = ex
 70   continue
c     print graph
      if (ne.ge.0) write (6,110) 
      if (ne.ge.0) write (6,111) plot(1),(nplot(ii),ii=1,22)
      if (ne.lt.0) write (6,110) 
      if (ne.lt.0) write (6,121) plot(1),(nplot(ii),ii=1,22)
      xlen = xlen*100./10.
      ylen = ylen*60./10.
      ymin = ymax
      if (ne.ge.0) ymin = 10.**ymax
      do 90 i=1,55,6
         write (6,130) ymin,(chart(i,j),j=1,61,1)
         if (i.eq.1) write (6,150) (plot(ii),ii=2,7)
         ymax = ymax-ylen
         if (ne.ge.0) ymin = 10.**ymax
         ip1 = i+1
         ip5 = i+5
         do 80 i1=ip1,ip5
            write (6,140) (chart(i1,j),j=1,61,1)
 80      continue
 90   continue
      write (6,130) ymin,(chart(61,j),j=1,61)
      do 100 i=1,7
         xf(i) = xmin
         xmin = xmin+xlen
 100  continue
      return
c
 110  format (1h1)
 111  format (1h+,7hsig(th),f6.1,2i4,4x,i1,i2,8i1,10i3)
 121  format (1h+,6h polar,f6.1,2i4,4x,i1,i2,8i1,10i3)
 130  format (1h ,e8.2,101a1)
 140  format (9x,101a1)
 150  format (1h+,20x,6f7.3)
      end
