      subroutine harmnuc(q2,nff,ff1,ff2)
c**********************************************************************
c              							      *
c *** Calculates gaussian form factor for harmonic oscillator nuclei  *
c								      *
c**********************************************************************
      implicit real*8(a-h,o-z)
      	       real*8 imtij,mpi,mn

      dimension nifty(20)
      dimension bnuc(20), bnucf(20), bn(16), bnf(16)
      dimension retij(14), imtij(14)

      common /sec2/ bnuc,bn,bnucf,bnf,retij,imtij,hbarc,pi,mpi,mn,nz,nes
     1              ,nwaves,nifty,na
      common /sec4/ achp,acmp,wsp,achn,acmn,wsn

**************** FIRST EXECUTABLE **************************************

      h2 = hbarc * hbarc

c *** protons

      rhl = q2 * achp * achp/4./h2
      rhl1 = acmp * acmp * q2/(6.0 * nz)/h2
      ff1 = 0.
      if (rhl .lt. 150.0) ff1 = (1.-(nz-2.)*rhl1)*exp(-rhl)

c *** divide out the proton form factor

      if (nifty(15) .eq. 0) ff1 = ff1 * (1.0 + q2/18.2/h2)**2
      if (nff .eq. 1) return

c *** neutron matter form factor

      rhl = q2 * achn * achn/4./h2
      rhl1 = acmn * acmn * q2/(6.0 * (na - nz))/h2
      ff2 = 0.
      if (rhl .lt. 150.0) ff2 = (1.-(na-nz-2.)*rhl1)*exp(-rhl)

c *** divide out the proton form factor

      if (nifty(15) .eq. 0) ff2 = ff2 * (1.0 + q2/18.2/h2)**2
      return

      end
