      subroutine ffhadj(q2mev,rp,rn,rpsp,rnsp,nif)

c**************************************************************************
c                                                                         *
c  calculates the matter and spin form factors of the protons and neutron *
c  in helium-3 from the charge and magnetic form factors of he-3 and h-3  *
c  as calculate by hadjimichael et. al. in the impulse approximation.     *
c                                                                         *
c  thus no meson currents are in the charge and magnetic form factors.    *
c                                                                         *
c**************************************************************************


      implicit real*8 (a-h,o-z)
      data up,un/2.79278,-1.91315/


c**************************************************************************
c                                                                         *
c  q2mev mustbe converted to inverse fermis squared                       *
c                                                                         *
c**************************************************************************


      qfer2 = q2mev/(197.329**2)
c
c
c**************************************************************************
c                                                                         *
c  now calculate the form factor of the proton                            *
c                                                                         *
c**************************************************************************
c
c
      call ffpn(qfer2,fp,fn)
c
c
c**************************************************************************
c                                                                         *
c  now calculate the charge and magnetic form factors of he-3 and h-3     *
c                                                                         *
c**************************************************************************
c
c
      call ffmec(qfer2,fche3,fch3,fmhe3,fmh3,nif)
c
c
c**************************************************************************
c                                                                         *
c  now calculate matter and spin form factors using formulas of mach that *
c  relate these to the charge and magnetic form factors of he-3 and h-3.  *
c                                                                         *
c**************************************************************************
c
c
      rp = fche3/fp
      rn = fch3/fp
      denom = fp*((up**2)-(un**2))
      rpsp = ((up*un)*(fmhe3-fmh3))/(2*denom)
      up2 = up**2
      un2 = un**2
      rnsp = (up2*fmh3-un2*fmhe3)/denom
      return
      end
