function [f,g,jac]=pidobj(x)
  
%  x = current iterate = [c,k]'
%  f = r^T r/2 = objective function is a scalar
%  gout = jac^T r = grad f(x) is a COLUMN vector
%  jac = r' = Jacobian of r is an M x N matrix
  
  global UDATA TDATA PARAMS
  
  c=x(1);
  k=x(2);
  
  % Solve ODE system with x=[c,k]' gives u=y(:,1):
  options=odeset('AbsTol',PARAMS.errtol,'RelTol',PARAMS.errtol);
  [t,y]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, c, k); 
  
  res=y(:,1)-UDATA;
  f=res'*res/2;
  
  if (nargout>1)
    if(0)
    % Compute Jacobian:
    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c*(1+PARAMS.h), k);
    jacc=z(:,1);

    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c*(1-PARAMS.h), k);
    jacc=(jacc-z(:,1))/2/c/PARAMS.h;
    
    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c, k*(1+PARAMS.h));
    jack=z(:,1);
    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c, k*(1-PARAMS.h));
    jack=(jack-z(:,1))/2/k/PARAMS.h;
    
    else
    % Compute Jacobian:
    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c*(1+PARAMS.h), k);
    jacc=(z(:,1)-y(:,1))/c/PARAMS.h;
    
    [t,z]=ode15s(@harmosc, TDATA, [PARAMS.u0 0], options, ...
		 c, k*(1+PARAMS.h));
    jack=(z(:,1)-y(:,1))/k/PARAMS.h;
    end

    jac=[jacc,jack];
    
    % Compute gradient:
    g=jac'*res;
  end
  
