global TDATA UDATA PARAMS

printflag=1;
linewidth=4; %0.5
markersize=10; %6

%Problem parameters:
PARAMS.M=100; %number of data points
PARAMS.c=1;   %parameter to be determined
PARAMS.k=1;   %parameter to be determined
PARAMS.T=10;  %time interval [0,T]
PARAMS.u0=10; %initial displacement

%Exact solution (data):
TDATA=linspace(0,PARAMS.T,PARAMS.M)';
r=(sqrt(PARAMS.c^2-4*PARAMS.k)-PARAMS.c)/2;
A=PARAMS.u0; B=-A*real(r)/imag(r);
UDATA=exp(real(r)*TDATA).*(A*cos(imag(r)*TDATA)+B*sin(imag(r)*TDATA));

%Solver parameters:
PARAMS.errtol=1e-8; %tol for ode15s
PARAMS.h=1e-4;      %stepsize for finite difference
gradtol=1e-4;       %tol for grad norm
maxits=1;           %maximum iterations


if(0)
% Check exact vs. numerical solution to ODE:
figure;plot(TDATA, UDATA,'-o')
set(gca,'FontSize',22);xlabel('t');ylabel('u');title('Data for u_0=10, c=k=1');
options=odeset('AbsTol',PARAMS.errtol,'RelTol',PARAMS.errtol);
[t,y]=ode15s(@harmosc,TDATA, [PARAMS.u0 0],options...
             ,PARAMS.c,PARAMS.k);
hold on
plot(t,y(:,1),'--g*')
legend('Exact data','Simulated solution at minimizer')

% Check "zero residual":
res0=pidobj([PARAMS.c,PARAMS.k])
end


inits=[1.1,1.05;1.75,1.75;3,1]; 
methodnames={'Newton''s Method','Gauss-Newton','Steepest Descent',...
	     'Levenberg-Marquardt'}



for repx0=3:3,
x0=inits(repx0,:)';
nu=0; % start with no noise
mthd1='Newton''s Method';
mthd2='Gauss-Newton';
mthd3='Steepest Descent';

for repnu=1:1,

if (nu)
  udatasave=UDATA;
  UDATA=UDATA.*(1+nu*(2*rand(size(UDATA))-1));
end

% initialize figure handle
figure;itf=gcf;

if (1)
% Call Newton's Method:
disp(' ')
disp(mthd1)
tic
[x,histout,costdata] = newton(x0,@pidobj,gradtol,maxits);
tNM=toc;


for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
  %disp(sprintf('%d & %.3e & %.3e',histout(i,4),histout(i,1),histout(i,2)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tNM));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd1)

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Function Value')
title(mthd1)

figure(itf)
plot(histout(1,5),histout(1,6),'ro','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
hold on
h1=plot(histout(:,5),histout(:,6),'-.r+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'rx','LineWidth',linewidth,'MarkerSize',markersize)

minc=min(histout(:,5));
maxc=max(histout(:,5));
mink=min(histout(:,6));
maxk=max(histout(:,6));

end

if (1)
% Call Gauss-Newton:
disp(' ')
disp(mthd2)
tic
[x,histout,costdata] = gaussn(x0,@pidobj,gradtol,maxits);
tGN=toc;


for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
  %disp(sprintf('%d & %.3e & %.3e',histout(i,4),histout(i,1),histout(i,2)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tGN));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd2)

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Function Value')
title(mthd2)

figure(itf)
plot(histout(1,5),histout(1,6),'ob','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
hold on
h2=plot(histout(:,5),histout(:,6),'-b+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'xb','LineWidth',linewidth,'MarkerSize',markersize)

minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);

end

if (1)
% Call Steepest-Descent
disp(' ')
disp(mthd3)
tic
[x,histout,costdata] = steepa(x0,@pidobj,gradtol,maxits);
tSD=toc;


for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
%  disp(sprintf('%d & %.3e & %.3e',histout(i,4),histout(i,1),histout(i,2)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tSD));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd3)

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Function Value')
title(mthd3)


minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);

end



legend([h1,h2],mthd1,mthd2,'Location','Best')



% plot contour
if repx0==1,
%  c=linspace(.95,1.15,5);
%  k=linspace(.95,1.1,5);
  c=linspace(min(1,max(0,.98*minc)),1.02*maxc,15);
  k=linspace(min(1,max(0,.98*mink)),1.02*maxk,15);  
else
  c=linspace(min(1,max(0,.9*minc)),1.1*maxc,15);
  k=linspace(min(1,max(0,.9*mink)),1.1*maxk,15);  
end
A=(0*k')*(0*c);
for i=1:length(c),
  for j=1:length(k),
    A(j,i)=pidobj([c(i),k(j)]);
  end
end
[C,K]=meshgrid(c,k);
figure(itf); contour(C,K,A,30,'k','LineWidth',linewidth)
  set(gca,'FontSize',22);
axis('tight')
ax=axis;
ax(1)=max(ax(1),.5);
ax(3)=max(ax(3),.5);
xlabel('c')
ylabel('k')
if repx0==1
  title('Iteration history')
else
  title('Search Direction')
end
pause(2)
if printflag
  bigprint('-depsc2',sprintf('NM_GN_x=%d.eps',repx0));
end

figure(itf)
plot(histout(1,5),histout(1,6),'og','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
hold on
h3=plot(histout(:,5),histout(:,6),'--g+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'xg','LineWidth',linewidth,'MarkerSize',markersize)
legend([h1,h2,h3],mthd1,mthd2,mthd3,'Location','SouthEast')
if printflag
  bigprint('-depsc2',sprintf('NM_GN_SD_x=%d.eps',repx0));
end

%mthd1=[mthd1,' with noise'];
%mthd2=[mthd2,' with noise'];
%mthd3=[mthd3,' with noise'];
%nu=.4;

end % repeat nu
%UDATA=udatasave;
maxits=1;

end % repeat x0

if (1)
% Call Levenberg-Marquardt
mthd4='Levenberg-Marquardt';
disp(' ')
disp(mthd4)
tic
[x,histout,costdata] = levmara(x0,@pidobj,gradtol);
tLM=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
%  disp(sprintf('%d & %.3e & %.3e',histout(i,4),histout(i,1),histout(i,2)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tLM));

% Plot results:
figure
semilogy(histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd4)

figure
semilogy(histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
xlabel('Iterations')
ylabel('Function Value')
title(mthd4)

figure(itf)
plot(histout(1,5),histout(1,6),'om','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',22);
hold on
h4=plot(histout(:,5),histout(:,6),'--m+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'xm','LineWidth',linewidth,'MarkerSize',markersize)
legend([h1,h2,h3,h4],mthd1,mthd2,mthd3,mthd4,'Location','SouthEast')
if printflag
  bigprint('-depsc2',sprintf('NM_GN_SD_LM_x=%d.eps',repx0));
end


end
