global TDATA UDATA PARAMS

printflag=0;
linewidth=4;
markersize=10;
fontsize=22;

PARAMS.M=100;
PARAMS.c=1;
PARAMS.k=1;
PARAMS.T=10;
PARAMS.u0=10;

PARAMS.errtol=1e-8;
PARAMS.h=1e-4;
gradtol=1e-4;
maxits=30;

x0=[5;1];

% Exact solution (data):
TDATA=linspace(0,PARAMS.T,PARAMS.M)';
r=(sqrt(PARAMS.c^2-4*PARAMS.k)-PARAMS.c)/2;
A=PARAMS.u0; B=-A*real(r)/imag(r);
UDATA=exp(real(r)*TDATA).*(A*cos(imag(r)*TDATA)+B*sin(imag(r)*TDATA));

% Check exact vs. numerical solution to ODE:
%figure;plot(TDATA, UDATA,'-o')
%options=odeset('AbsTol',PARAMS.errtol,'RelTol',PARAMS.errtol);
%figure;ode15s(@harmosc,[0 PARAMS.T], [PARAMS.u0 0],options...
%             ,PARAMS.c,PARAMS.k);

% Check "zero residual":
res0=pidobj([PARAMS.c,PARAMS.k])

% initialize figure handle
figure;itf=gcf;


if (1)
% Call Newton Trust Region:
disp('Newton Trust Region')
tic
[x,histout,costdata] = ntrust(x0,@pidobj,gradtol,maxits);
tNTR=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, trad=%g, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tNTR));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Gradient Norm')
title('Newton Trust Region')

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Newton Trust Region')


figure(itf)
plot(histout(1,5),histout(1,6),'ro','LineWidth',linewidth,'MarkerSize',markersize)
hold on
h1=plot(histout(:,5),histout(:,6),'-.r+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'rx','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);

minc=min(histout(:,5));
maxc=max(histout(:,5));
mink=min(histout(:,6));
maxk=max(histout(:,6));
end

if (1)
% Call Levenberg-Marquardt:
disp('Levenberg-Marquardt')
tic
[x,histout,costdata] = levmar(x0,@pidobj,gradtol,maxits);
tLMTR=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tLMTR));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Gradient Norm')
title('Levenberg-Marquardt')

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Levenberg-Marquardt')

figure(itf)
plot(histout(1,5),histout(1,6),'go','LineWidth',linewidth,'MarkerSize',markersize)
hold on
h2=plot(histout(:,5),histout(:,6),'g--+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'gx','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);

minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);
end

xlabel('c')
ylabel('k')
title('Iteration history')
legend([h1,h2],'Newton Trust Region','Levenberg-Marquardt TR',...
       'Location','Best')

% plot contour
%k=[.95:.01:1.1];
%c=[.95:.01:1.15];
  c=linspace(min(1,max(0,.98*minc)),1.02*maxc,20);
  k=linspace(min(1,max(0,.98*mink)),1.02*maxk,20);  
A=(0*k')*(0*c);
for i=1:length(c),
  for j=1:length(k),
    A(j,i)=pidobj([c(i),k(j)]);
  end
end
%figure; surf(c,k,A)
[C,K]=meshgrid(c,k);
figure(itf); contour(C,K,A,30,'k','LineWidth',linewidth)
axis('tight')
