global TDATA UDATA PARAMS

PARAMS.M=100;
PARAMS.c=1;
PARAMS.k=1;
PARAMS.T=10;
PARAMS.u0=10;

PARAMS.errtol=1e-8;
PARAMS.h=1e-4;
gradtol=1e-4;
maxits=10;

x0=[1.1;1.05];

% Exact solution (data):
TDATA=linspace(0,PARAMS.T,PARAMS.M)';
r=(sqrt(PARAMS.c^2-4*PARAMS.k)-PARAMS.c)/2;
A=PARAMS.u0; B=-A*real(r)/imag(r);
UDATA=exp(real(r)*TDATA).*(A*cos(imag(r)*TDATA)+B*sin(imag(r)*TDATA));

% Check exact vs. numerical solution to ODE:
%figure;plot(TDATA, UDATA,'-o')
%options=odeset('AbsTol',PARAMS.errtol,'RelTol',PARAMS.errtol);
%figure;ode15s(@harmosc,[0 PARAMS.T], [PARAMS.u0 0],options...
%             ,PARAMS.c,PARAMS.k);

% Check "zero residual":
res0=pidobj([PARAMS.c,PARAMS.k])


for repx0=1:2,
nu=0; % start with no noise
mthd1='Newton''s Method';
mthd2='Gauss-Newton';

for repnu=1:1,

if (nu)
  UDATA=UDATA+nu*(2*rand(size(UDATA))-1);
end

% initialize figure handle
figure;itf=gcf;

if (1)
% Call Newton's Method:
disp(' ')
disp(mthd1)
tic
[x,histout,costdata] = newton(x0,@pidobj,gradtol,maxits);
tNM=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tNM));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o')
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd1)

figure
semilogy([0:histout(end,4)],histout(:,2),'-o')
xlabel('Iterations')
ylabel('Function Value')
title(mthd1)

figure(itf)
plot(histout(1,5),histout(1,6),'ro')
hold on
h1=plot(histout(:,5),histout(:,6),'-.r+');
plot(histout(end,5),histout(end,6),'rx')

minc=min(histout(:,5));
maxc=max(histout(:,5));
mink=min(histout(:,6));
maxk=max(histout(:,6));

end

if (1)
% Call Gauss-Newton:
disp(' ')
disp(mthd2)
tic
[x,histout,costdata] = gaussn(x0,@pidobj,gradtol,maxits);
tGN=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tGN));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o')
xlabel('Iterations')
ylabel('Gradient Norm')
title(mthd2)

figure
semilogy([0:histout(end,4)],histout(:,2),'-o')
xlabel('Iterations')
ylabel('Function Value')
title(mthd2)

figure(itf)
plot(histout(1,5),histout(1,6),'ob')
hold on
h2=plot(histout(:,5),histout(:,6),'-b+');
plot(histout(end,5),histout(end,6),'xb')

minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);

end



xlabel('c')
ylabel('k')
title('Iteration history')
legend([h1,h2],mthd1,mthd2,'Location','Best')



% plot contour
if repx0==1,
  c=linspace(.95,1.15,5);
  k=linspace(.95,1.1,5);
else
  c=linspace(max(0,.9*minc),1.1*maxc,5);
  k=linspace(max(0,.9*mink),1.1*maxk,5);  
end
A=(0*k')*(0*c);
for i=1:length(c),
  for j=1:length(k),
    A(j,i)=pidobj([c(i),k(j)]);
  end
end
[C,K]=meshgrid(c,k);
figure(itf); contour(C,K,A,30,'k')
axis('tight')

mthd1=[mthd1,' with noise'];
mthd2=[mthd2,' with noise'];
nu=.25;

end % repeat nu
maxits=1;
x0=[3;1];
end % repeat x0
