global TDATA UDATA PARAMS

printflag=0;
linewidth=4;
markersize=10;
fontsize=22;

PARAMS.M=100;
PARAMS.c=1;
PARAMS.k=1;
PARAMS.T=10;
PARAMS.u0=10;

PARAMS.errtol=1e-8;
PARAMS.h=1e-6;
gradtol=1e-4;
maxits=10;

%x0=[1.1;1.05];
x0=[1.75;1.75];
%x0=[3;1];

% Exact solution (data):
TDATA=linspace(0,PARAMS.T,PARAMS.M)';
r=(sqrt(PARAMS.c^2-4*PARAMS.k)-PARAMS.c)/2;
A=PARAMS.u0; B=-A*real(r)/imag(r);
UDATA=exp(real(r)*TDATA).*(A*cos(imag(r)*TDATA)+B*sin(imag(r)*TDATA));

% Check exact vs. numerical solution to ODE:
%figure;plot(TDATA, UDATA,'-o')
%options=odeset('AbsTol',PARAMS.errtol,'RelTol',PARAMS.errtol);
%figure;ode15s(@harmosc,[0 PARAMS.T], [PARAMS.u0 0],options...
%             ,PARAMS.c,PARAMS.k);

% Check "zero residual":
res0=pidobj([PARAMS.c,PARAMS.k])

% initialize figure handle
figure;itf=gcf;

if (1)
% Call Damped Gauss-Newton with Armijo rule:
disp('Damped Gauss-Newton with Armijo rule:')
tic
[x,histout,costdata,fhistout] = dgaussna(x0,@pidobj,gradtol,maxits);
tDGNA=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tDGNA));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Gradient Norm')
title('Gauss-Newton with Armijo rule')

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Gauss-Newton with Armijo rule')
hold on
for i=1:histout(end,4),
  if histout(i+1,3)>0
    semilogy(linspace(i-1,i,histout(i+1,3)+2),...
	     [histout(i,2),fhistout(i+1,1:histout(i+1,3)+1)],'--g*',...
	     'LineWidth',linewidth,'MarkerSize',markersize)
  end
end
legend('Iterations','Pullbacks');
ax=axis;

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Gauss-Newton with Armijo rule')
axis(ax)

figure(itf)
plot(histout(1,5),histout(1,6),'ob','LineWidth',linewidth,'MarkerSize',markersize)
hold on
h1=plot(histout(:,5),histout(:,6),'-b+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'xb','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('c')
ylabel('k')
title('Iteration history')
minc=min(histout(:,5));
maxc=max(histout(:,5));
mink=min(histout(:,6));
maxk=max(histout(:,6));

end

if (1)
% Call Steepest Descent with Armijo rule:
disp('Steepest Descent with Armijo rule:')
tic
[x,histout,costdata,fhistout] = steepa(x0,@pidobj,gradtol,maxits);
%[x,histout,costdata] = steep(x0,@pidobj,gradtol,4);
tSDA=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tSDA));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Gradient Norm')
title('Steepest Descent with Armijo rule')

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Steepest Descent with Armijo rule')
hold on
for i=1:histout(end,4),
  if histout(i+1,3)>0
    semilogy(linspace(i-1,i,histout(i+1,3)),...
	     [histout(i,2),fhistout(i+1,3:histout(i+1,3)+1)],'--g*',...
	     'LineWidth',linewidth,'MarkerSize',markersize)
  end
end
legend('Iterations','Pullbacks');
ax=axis;

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Steepest Descent with Armijo rule')
axis(ax)

figure(itf)
plot(histout(1,5),histout(1,6),'go','LineWidth',linewidth,'MarkerSize',markersize)
hold on
h2=plot(histout(:,5),histout(:,6),'--g+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'gx','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);

xlabel('c')
ylabel('k')
title('Iteration history')
minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);

end

if (1)
% Call LMA
disp('LMA')
tic
[x,histout,costdata] = levmara(x0,@pidobj,gradtol,maxits);
tLMA=toc;
x

for i=1:size(histout,1)
  disp(sprintf('norm(grad)=%d, f=%d, pullbacks=%d, its=%d',histout(i,1:4)));
end
disp(sprintf('fcns=%d, grads=%d, hess=%d, time=%g',costdata,tLMA));

% Plot results:
figure
semilogy([0:histout(end,4)],histout(:,1),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Gradient Norm')
title('Levenberg-Marquardt')

figure
semilogy([0:histout(end,4)],histout(:,2),'-o','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);
xlabel('Iterations')
ylabel('Function Value')
title('Levenberg-Marquardt')
end

figure(itf)
plot(histout(1,5),histout(1,6),'ro','LineWidth',linewidth,'MarkerSize',markersize)
hold on
h3=plot(histout(:,5),histout(:,6),'-.r+','LineWidth',linewidth,'MarkerSize',markersize);
plot(histout(end,5),histout(end,6),'rx','LineWidth',linewidth,'MarkerSize',markersize)
  set(gca,'FontSize',fontsize);

xlabel('c')
ylabel('k')
title('Iteration history')
legend([h1,h2,h3],'Gauss-Newton','Steepest Descent','Levenberg-Marquardt',...
       'Location','Best')

minc=min([minc;histout(:,5)]);
maxc=max([maxc;histout(:,5)]);
mink=min([mink;histout(:,6)]);
maxk=max([maxk;histout(:,6)]);

% plot contour
%k=[.95:.01:1.1];
%c=[.95:.01:1.15];
  c=linspace(min(1,max(0,.98*minc)),1.02*maxc,15);
  k=linspace(min(1,max(0,.98*mink)),1.02*maxk,15);  
A=(0*k')*(0*c);
for i=1:length(c),
  for j=1:length(k),
    A(j,i)=pidobj([c(i),k(j)]);
  end
end
%figure; surf(c,k,A)
[C,K]=meshgrid(c,k);
figure(itf); contour(C,K,A,30,'k','LineWidth',linewidth)
axis('tight')
