function [x,histout,costdata] = ntrust(x0,f,tol,maxit,resolution)
%
%
% C. T. Kelley, Dec 15, 1997
%
% This code comes with no guarantee or warranty of any kind.
%
% function [x,histout,costdata] = newton(x0,f,tol,maxit,resolution)
%
% Newton model, dense algorithm 
%
% Input: x0 = initial iterate
%        f = objective function,
%            the calling sequence for f should be
%            [fout,gout]=f(x) where fout=f(x) is a scalar
%              and gout = grad f(x) is a COLUMN vector
%        tol = termination criterion norm(grad) < tol
%        maxit = maximum iterations (optional) default = 100
%        resolution = estimated accuracy in functions/gradients (optional)
%                     default = 1.d-12
%                     The finite difference increment in the difference
%                     Hessian is set to sqrt(resolution). 
%                     
%
% Output: x = solution
%         histout = iteration history   
%             Each row of histout is
%       [norm(grad), f, TR radius, iteration count, xc] 
%         costdata = [num f, num grad, num hess] 
%
% Requires: diffhess.m, dirdero.m
%
% set maxit, the resolution, and the difference increment
%
debug=0;
if nargin < 4
maxit = 100;
end
if nargin < 5
resolution = 1.d-12;
end
hdiff=sqrt(resolution);
%
itc=1; xc=x0; n=length(x0);
[fc,gc]=feval(f,xc);
numf=1; numg=1; numh=0;
ithist=zeros(maxit,4+n);
ithist(1,1)=norm(gc); ithist(1,2) = fc; ithist(1,4)=itc-1;
ithist(1,3)=0;
ithist(1,5:end)=xc;
if debug == 1
ithist(itc,:)
end

while(norm(gc) > tol & itc <= maxit)
  hc=diffhess(xc,f,gc,hdiff);
  numf=numf+n; numg=numg+n; numh=numh+1;
  itc=itc+1;
  dsd=-gc; 
  dnewt=hc\dsd;
  xc=xc+dnewt;
  [fc,gc]=feval(f,xc);
  numf=numf+1; numg=numg+1;
  ithist(itc,1)=norm(gc); ithist(itc,2) = fc;
  ithist(itc,4)=itc-1; ithist(itc,3)=0;
  ithist(itc,5:end)=xc;
  if debug == 1
    ithist(itc,:)
  end
end
x=xc; histout=ithist(1:itc,:);
costdata=[numf, numg, numh];
