
n = 200; % time points
M = 10;  % number of data ensembles
NKL = 5;  % number of terms to keep in the KL

% comment out the following if it does not work on your machine
rng('default') %sets the random number generator seed so we all get the same answers
%rng('shuffle') %randomizes the random number generator seed

%% Input the data (although here we are generating synthetic data)
[x,ProdData] = GenerateEnsembles(n,M);
figure
plot(x,ProdData,'b');hold on
title('Synthesized Data');

%% Compute Mean and Covariance of data
MeanK = mean(ProdData,2);
C=cov(ProdData')';

%% Compute the eigenvalues and eigenfunctions of the data
[lambda,phi] = IntEqSolver1d(x(1),x(end),length(x),C,NKL,'collocation',1,0);

%% Display results
figure;
plot(lambda,'-ok');
title('Eigenvalues');

figure;
plot(x,phi,'Linewidth',2);
legend('1st','2nd','3rd','4th','5th','6th');
title('Eigenfunctions');

figure
plot(x,MeanK,'--k','Linewidth',4);
hold on
plot(x,phi*diag(lambda),'Linewidth',2);
legend('Mean','1st','2nd','3rd','4th','5th','6th');
title('Scaled Eigenfunctions');

%% sample the KL to generate simulated realizations
nrel = 20;
dK = zeros(n,nrel);
for j = 1:nrel
 Z = sqrt(lambda).*randn(NKL,1); % assume random coefficients are N(0,1)
 dK(:,j) = phi*Z;
end

figure;
plot(x,dK+MeanK*ones(1,size(dK,2)));
hold on
hm=plot(x,MeanK,'--k','Linewidth',4);
legend(hm,'Mean');
title(['Sampled Realizations with NKL=',num2str(NKL)]);
